-- Owner für DemoDaten
SET SESSION AUTHORIZATION 'DEMODATA';

--Warenwirtschaft: Standardprozess: Verkauf (Rahmen und Abruf) > PA > ABK, Lager
  DO $$
    DECLARE
        s VARCHAR;
        --Datum --TODO: ACHTUNG ALLE DATUM: ABFANGEN DAS AUF WOCHENENDE
            dat_folgejahr               DATE:= current_date + interval '1 year';
            dat_monat_folgemonat_erster DATE:=(SELECT date_trunc('month', current_date + interval '1 month')); --  01. des Folgemonats --achtung dat_current_plus_1_monat
            dat_current_minus_2_monat   DATE:=current_date - interval '2 month';
            dat_current_minus_1_monat   DATE:=current_date - interval '1 month';
            dat_current_minus_1_week    DATE:=current_date - interval '1 week';
            dat_current_minus_5_day     DATE:=current_date-5;
            dat_current_plus_15_day     DATE:=current_date+15;
            dat_current_plus_1_monat    DATE:=current_date + interval '1 month'; --achtung dat_monat_folgemonat_erster
        --Artikel
            art_getriebe                VARCHAR :='G.PKW.A-1168534 /A';
            art_getriebe_mgcid          INTEGER :=tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_getriebe);
            art_welle                   VARCHAR :='W.13.N-272.371 /C';
            art_welle_mgcid             INTEGER :=tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_welle);
            art_bc_getriebe_sensor      VARCHAR :='E.B.PKW.A-1168534-0100 /A';
            art_bc_getriebe_sensor_mgcid   INTEGER :=tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_bc_getriebe_sensor);
            --2 weitere für Positionsgenerierung: Lagerzugang tabellarisch usw.
            art_bc_platine              VARCHAR :='E.B.PKW.A-1168534-0001 /A';
            art_bc_platine_mgcid        INTEGER :=tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_bc_platine);
            --L Profil mit Zuschnitt
            art_lprofil                 VARCHAR :='L.100X1000-0001';
            art_lprofil_mgcid           INTEGER :=tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(art_lprofil);
        --Adressen
            adk_kunde_getr              VARCHAR :='AUTO-AG';
            adk_kunde_auto              VARCHAR :='GETRIEBE-GMBH';
            adk_lief_elek               VARCHAR :='ELEKTR';
        --Sonstiges
            steu_steucode_auftg         INTEGER :=TSystem.Settings__Get('auftgsteucode');
        --Verkauf
            auftg_rahmen_ag_bda_ident   VARCHAR :='RA-0011';
            auftg_rahmen_ag_id          INTEGER; --zuweisen durch returning bei insert into auftg

            auftg_welle_ag_id_plus15    INTEGER;
        --Einkauf, ABK
            ldsdoki_welle_ld_id_plus15  INTEGER;
            ldsdoki_welle_abix_plus15   INTEGER;
            ldsdoke_ld_id_getriebe_sensor     INTEGER;
            ldsdoke_sernrident         VARCHAR := 'SERNR-'||current_date;
    BEGIN
    --VERKAUF
      --Verkaufsaufträge
       --Auftrag von AUTO-AG zum Anlegen der Reklamation
         INSERT INTO auftg
          (ag_astat, ag_nr, ag_pos, ag_bda, ag_lkn, ag_aknr, ag_stk, ag_preis, ag_mcv,
                ag_datum, ag_bdat, ag_kdatum, ag_ldatum,
                ag_steucode, ag_ustpr, ag_prkl, ag_kukl)
           VALUES --4 Einzelaufträge Getriebe
              --Rückstand 1 Woche Auftragseingang -60
              ('E', getnumcirclenr('eauftg'), 1, 'REKLAM', adk_kunde_auto, art_getriebe, 120, 876.54, art_getriebe_mgcid,
                dat_current_minus_2_monat, dat_current_minus_2_monat, dat_current_minus_1_monat, dat_current_minus_1_week,
                steu_steucode_auftg, 19, 1, 1)
           RETURNING ag_id INTO s;
    --Serviceanfrage
         INSERT INTO kundanfrage
           (kanf_nr, kanf_isservice, kanf_ag_id, kanf_ad_krz, kanf_ak_nr, kanf_via, kanf_art,
            kanf_txt)
          VALUES
           (getnumcirclenr('kanfrageser'), true, s::INTEGER, adk_kunde_auto, art_getriebe, 'EMail', 'ES',
            'Nach längerer Belastung Ölaustritt.')
          RETURNING kanf_nr INTO s;
         INSERT INTO kundservicepos --Fehlerposition
          (kanfse_kanf_nr, kanfse_pos, kanfse_sfall) VALUES (s, 10, 'Undichtigkeit');
         --INSERT INTO qab --QAB zur Serviceanfrage
         -- ()
         -- VALUES
         -- ();


END $$ LANGUAGE plpgsql;
--
DO $$       -- #8385 Preissuche im Einkauf und Zuschläge
  DECLARE I Integer;
    mat_aknr      VARCHAR   := '1.2210 Ø14X1000-URT';
    mat_bez     VARCHAR   := 'uRT-Silberstahl Rundstange / Welle DIN 175';
    mat_stk   INTEGER   := 100;
    mat_preis   NUMERIC(16, 4)  := 20;
    mat_ld_auftg  VARCHAR(30);
    mat_pos     INTEGER;
    mat_erg_nr    VARCHAR(30);
    mat_ltd_dokunr  INTEGER;
    mat_ld_id   INTEGER;
    mat_rhl_nr    VARCHAR(40);
    mat_wendat_dbrid  INTEGER;
    mat_ak_los    INTEGER   := 10;
    mat_e_rab   NUMERIC   := 50;
    mybvs_nr            VARCHAR(40);
    my_nr             VARCHAR;
    my_pos    INTEGER;
    my_dokunr   INTEGER;
    adk_kunde_getr    VARCHAR       :='GETRIEBE-GMBH';
    aang_alief_id INTEGER;
    my_anfnr    VARCHAR(30);
    aang_steucode1  INTEGER;
    aang_steuproz1  NUMERIC(5,2);
    aAng__id            INTEGER;
    aang_aart_id  INTEGER;
    akbtxt          TEXT;
    akbtxtrtf           TEXT;
    prefix    VARCHAR(4)  := 'URT-';

 BEGIN

    PERFORM tartikel.art__ak_nr__delete( ak_nr )
    FROM art
    WHERE ak_nr in( mat_aknr );

    INSERT INTO art (ak_ac   , ak_nr   , ak_bez , ak_mat   , ak_dim     , ak_din  , ak_standard_mgc, ak_gewicht, ak_bfr, ak_hest, ak_vkpbas, ak_los    , ak_canRabatt)
     VALUES         ('RM1001', mat_aknr, mat_bez, '115CrV3', 'Ø 14x1000', '1.2210', 4              , 1.2       ,     20, 20     , 25       , mat_ak_los, TRUE        ); --Faktor 1.25 in Vorgaben, beachte Lieferantendpreise übereinstimmend

    --- Lieferant 'STAHL'
    INSERT INTO epreis (e_aknr  , e_lkn  , e_stk  , e_ep     , e_mcv                    , e_lfzt, e_stal, e_rab    )
     VALUES            (mat_aknr, 'STAHL', mat_stk, mat_preis, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_aknr), 20    , true  , mat_e_rab)
     RETURNING e_id INTO i;

    INSERT INTO twawi.epreis_abzu (az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag)
     VALUES                       ('E'    , 9001  , 9001     , i           , 1        , 200      );

    INSERT INTO twawi.epreis_abzu (az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_proz)
     VALUES                       ('E'    , 9006  , 9006     , i           , 1        , 10     );

    INSERT INTO twawi.epreis_abzu (az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag)
     VALUES                       ('M'    , 100   , 100      , i           , mat_stk  , 2        );
    ---

    --- Lieferant 'ZERSP'                                                                                                                                 --Hinweis: Summe 90, dadurch Grundpreis Artikelstamm gerade
    INSERT INTO epreis (e_aknr  , e_lkn  , e_stk  , e_ep     , e_mcv                    , e_lfzt, e_stal, e_rab    )
     VALUES            (mat_aknr, 'ZERSP', mat_stk, mat_preis, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_aknr), 20    , false , mat_e_rab)
     RETURNING e_id INTO i;

    --- Lieferant-Staffelpreise
    INSERT INTO epreisstaffel (est_e_id, est_mengevon, est_mengebis, est_ep)
     VALUES                   (i       , 0           , 10          , 25);

    INSERT INTO epreisstaffel (est_e_id, est_mengevon, est_mengebis, est_ep)
     VALUES                   (i       , 11          , 50          , 20);

    INSERT INTO epreisstaffel (est_e_id, est_mengevon, est_mengebis, est_ep)
     VALUES                   (i       , 51          , 200         , 15);

    --- Ab/Zuschläge anlegen
    INSERT INTO twawi.epreis_abzu (az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag)
     VALUES                       ('E'    , 9001  , 9001     , i           , 1        , 200      );

    INSERT INTO twawi.epreis_abzu (az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_proz)
     VALUES                       ('E'    , 9006  , 9006     , i           , 1        , 10     );

    INSERT INTO twawi.epreis_abzu (az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag)
     VALUES                       ('M'    , 100   , 100      , i           , mat_stk  , 2        );
    ---

    mat_ld_auftg := prefix || (TEinkauf.Generate_Bestellnummer_Ext('R')).nummer;
    mat_pos    := TSystem.Settings__GetInteger('LD_POS_WIDTH');
    --- Eingangsrechnungsnummer
    mat_erg_nr :=  prefix || getnumcirclenr('eingrechnr');
    --- Dokument für Einkaufposition anlegen
    mat_ltd_dokunr := nextval('ldsdok_ld_dokunr_seq');

    --- Rahmenbestellung  anlegen
    INSERT INTO ldsdok
             (ld_arab, ld_eklos, ld_dokunr     , ld_code, ld_auftg    , ld_pos ,  ld_kn  , ld_aknr , ld_stk, ld_datum        , ld_preis, ld_preiseinheit, ld_ep, ld_kurs, ld_mce                   , ld_steucode, ld_steuproz, ld_ekp_mce                , insert_by, insert_date)
     VALUES
             (50     , 100     , mat_ltd_dokunr, 'R'    , mat_ld_auftg, mat_pos,  'STAHL', mat_aknr, 1000  , current_date-130, mat_preis, 1              , 0    , 1      , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_aknr), 9          , 19         , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_aknr), current_user, current_date)
     RETURNING ld_id INTO mat_ld_id;

    --- Ab/Zuschläge anlegen
    INSERT INTO ldsabzu (ldaz_type, ldaz_pos, ldaz_abz_id, ldaz_ld_id, ldaz_anz, ldaz_betr)
     VALUES             ('A'      , 9001    , 9001       , mat_ld_id , 1       , 200      );

    INSERT INTO ldsabzu (ldaz_type, ldaz_pos, ldaz_abz_id, ldaz_ld_id, ldaz_anz, ldaz_proz)
     VALUES             ('E'      , 9006    , 9006       , mat_ld_id , 1       , 10     );

    INSERT INTO ldsabzu (ldaz_type, ldaz_pos, ldaz_abz_id, ldaz_ld_id, ldaz_anz, ldaz_betr)
     VALUES             ('M'      , 100     , 100        , mat_ld_id , mat_stk , 2        );
    ---

    --- Bestellung mit 'ld_rhl_nr' anlegen
    mat_ltd_dokunr := nextval('ldsdok_ld_dokunr_seq');
    mat_ld_auftg := prefix || (TEinkauf.Generate_Bestellnummer_Ext('E')).nummer;
    mat_pos    := TSystem.Settings__GetInteger('LD_POS_WIDTH');
    SELECT  concat_ws('/', ld_auftg, ld_pos) INTO mat_rhl_nr FROM ldsdok WHERE ld_id = mat_ld_id;

    INSERT INTO ldsdok
        (ld_arab, ld_eklos  , ld_rhl_nr , ld_dokunr     , ld_code, ld_auftg    , ld_pos ,  ld_kn  , ld_aknr , ld_stk , ld_datum        , ld_preis, ld_preiseinheit, ld_ep, ld_kurs, ld_mce                   , ld_steucode, ld_steuproz, ld_ekp_mce                , insert_by, insert_date)
     VALUES
        (50     ,mat_ak_los, mat_rhl_nr, mat_ltd_dokunr, 'E'    , mat_ld_auftg, mat_pos,  'STAHL', mat_aknr, mat_stk, current_date-130, mat_preis, 1              , 0    , 1      , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_aknr), 9          , 19         , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_aknr), current_user, current_date)
     RETURNING ld_id INTO mat_ld_id;

    --- Ab/Zuschläge anlegen
    INSERT INTO ldsabzu (ldaz_type, ldaz_pos, ldaz_abz_id, ldaz_ld_id, ldaz_anz, ldaz_betr)
     VALUES             ('E'      , 9001    , 9001       , mat_ld_id , 1       , 200      );

    INSERT INTO ldsabzu (ldaz_type, ldaz_pos, ldaz_abz_id, ldaz_ld_id, ldaz_anz, ldaz_proz)
     VALUES             ('E'      , 9006    , 9006       , mat_ld_id , 1       , 10     );

    INSERT INTO ldsabzu (ldaz_type, ldaz_pos, ldaz_abz_id, ldaz_ld_id, ldaz_anz, ldaz_betr)
     VALUES             ('M'      , 100     , 100        , mat_ld_id , mat_stk , 2        );
    ---

    --- Lagerzungang
    INSERT INTO wendat
        (w_aknr  , w_lds_id , w_zug_dat         , w_lgort  , w_lagort, w_lagbereich, w_lgchnr, w_zugang   , w_zug_mec                , insert_by, insert_date)
     VALUES
  (mat_aknr, mat_ld_id, current_date - 120, 'H2 | R1', 'R1'    , 'H2'        , '187'   , mat_stk , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_aknr), current_user, current_date)
     RETURNING dbrid INTO mat_wendat_dbrid;

     --- EingagsrechnungKopf anlegen
     PERFORM TBeleg.EingrechDokumentFromWendat(mat_wendat_dbrid, mat_erg_nr);

     --- Eingangsrechnungsposition anlegen
     PERFORM TBeleg.BelegPosFromWendatPos('ERG', mat_wendat_dbrid::VARCHAR, mat_erg_nr, mat_stk);

     --- 'STAHL'
     INSERT INTO anfrage (anf_nr) VALUES (prefix || getnumcirclenr('anfrage'))
     RETURNING anf_nr INTO my_anfnr;

     INSERT INTO anfart (aart_ak_nr , aart_anf_nr, aart_menge, aart_m_id, aart_pos) VALUES (mat_aknr, my_anfnr, 50, 4, COALESCE((SELECT MAX(COALESCE(aart_pos, 0)) + 1 FROM anfart WHERE aart_anf_nr = my_anfnr), 1))
     RETURNING aart_id INTO aang_aart_id;

     --- Anfragelieferant anlegen
     INSERT INTO anflief (alief_anf_nr, alief_lkn) VALUES (my_anfnr, 'STAHL')
     RETURNING alief_id INTO aang_alief_id;

     --- Steuercode, Steuerprozent
     SELECT A1_WUCO, steu_proz INTO aang_steucode1, aang_steuproz1 FROM adk1 JOIN steutxt ON steu_z = a1_wuco WHERE a1_krz = 'STAHL';

     --- Angebot 'STAHL' erstellen
     INSERT INTO anfangebot
      (aang_alief_id, aang_aart_id, aang_datum, aang_txt, aang_txt_rtf, aang_steucode, aang_steuproz, aang_lieferzeit, aang_preis)
     VALUES
      (aang_alief_id, aang_aart_id, current_date, akbtxt, akbtxtrtf, aang_steucode1, aang_steuproz1,
      (SELECT e_lfzt FROM epreis WHERE e_aknr = mat_aknr AND e_lkn = 'STAHL'),
      (SELECT e_preis FROM epreis WHERE e_aknr = mat_aknr AND e_lkn = 'STAHL'))
      RETURNING aAng_id  INTO aAng__id;

     INSERT INTO twawi.anfangebot_abzu(az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag) VALUES ('P', 9001, 9001, aAng__id, 1, 15); --'uRT-Transport-Abzu-Betrag 15'
     INSERT INTO twawi.anfangebot_abzu(az_type, az_pos, az_abz_id, az_parent_id, az_anzahl, az_betrag) VALUES ('P', 9003, 9003, aAng__id, 1, 75); --'uRT-Rüstkosten-Matzeugnis B 75 S 7'

     ---
 END $$ LANGUAGE plpgsql;

-- END DEMO-SESSION
RESET SESSION AUTHORIZATION;